
\def\filedate{2014/12/1}
\let\utnsfiledate\filedate
\def\fileversion{8.3}
\let\utnsfileversion\fileversion
\NeedsTeXFormat{LaTeX2e}[1995/06/01]
\ProvidesClass{utns}
         [\filedate{} v\fileversion{} Class for UTNS journal]
\LoadClass[fleqn]{article}
\newif\ifutns@letter
\DeclareOption{letter}{\utns@lettertrue}
\newif\ifutns@onlletter
\DeclareOption{onlletter}{\utns@onllettertrue}
\newif\ifutns@online
\DeclareOption{online}{\utns@onlinetrue}
\newif\ifutns@referee
\DeclareOption{referee}{\utns@refereetrue}
\newif\ifutns@rnote
\DeclareOption{rnote}{\utns@rnotetrue}
\newif\ifutns@contents
\DeclareOption{contents}{\utns@contentstrue}
\newif\ifutns@contentsAut
\DeclareOption{contentsAut}{\utns@contentsAuttrue}
\newlength\utns@fullwidth
\newlength\utns@fullheight
\DeclareOption{a4paper}{%
  \renewcommand*\utns@paper{a4paper}%
  \setlength\utns@fullwidth{184mm}%
  \renewcommand*\utns@leftmarginpaper{(21cm-\utns@fullwidth)/2}%
  \setlength\utns@fullheight{705pt}%
}
\DeclareOption{letterpaper}{%
  \renewcommand*\utns@paper{letterpaper}
  \setlength\utns@fullwidth{184mm}%
  \renewcommand*\utns@leftmarginpaper{(8.5in-\utns@fullwidth)/2}%
  \setlength\utns@fullheight{705pt-1.76cm}%
}
\DeclareOption{legalpaper}{%
  \renewcommand*\utns@paper{legalpaper}%
  \setlength\utns@fullwidth{184mm}%
  \renewcommand*\utns@leftmarginpaper{(8.5in-\utns@fullwidth)/2}%
  \setlength\utns@fullheight{705pt}%
}
\newcommand*\utns@paper{}
\newcommand*\utns@leftmarginpaper{}
\newif\ifutns@twocolumn
\DeclareOption{onecolumn}{%
  \utns@twocolumnfalse
  \renewcommand*\utns@column{onecolumn}%
}
\DeclareOption{twocolumn}{%
  \utns@twocolumntrue
  \renewcommand*\utns@column{twocolumn}%
}
\newcommand*\utns@column{}
\newif\if@wideboxfn
\@wideboxfnfalse
\DeclareOption{wideboxfn}{\@wideboxfntrue}
%
\newif\ifutns@longfn
\DeclareOption{longfn}{\utns@longfntrue}
\newif\ifutns@longauth
\DeclareOption{longauth}{\utns@longauthtrue}
\DeclareOption{ascii}{%
  \def\utns@inputenc{\RequirePackage[ascii]{inputenc}}%
}
\DeclareOption{latin1}{%
  \def\utns@inputenc{\RequirePackage[latin1]{inputenc}}%
}
\DeclareOption{latin9}{%
  \def\utns@inputenc{\RequirePackage[latin9]{inputenc}}%
}
\DeclareOption{ansinews}{%
  \def\utns@inputenc{\RequirePackage[ansinews]{inputenc}}%
}
\DeclareOption{applemac}{%
  \def\utns@inputenc{\RequirePackage[applemac]{inputenc}}%
}
\DeclareOption{utf8}{%
  \def\utns@inputenc{\RequirePackage[utf8]{inputenc}}%
}
\newcommand*\utns@font{}
\DeclareOption{cm}{%
  \def\utns@font{%
    \RequirePackage{textcomp}%
  }%
}
\DeclareOption{showoverfull}{\setlength\overfullrule{5\p@}}
\DeclareOption{hideoverfull}{\setlength\overfullrule{\z@}}
\DeclareOption{openbib}{%
  \AtEndOfPackage{%
   \renewcommand\@openbib@code{%
      \advance\leftmargin\bibindent
      \itemindent -\bibindent
      \listparindent \itemindent
      \parsep \z@
      }%
   \renewcommand\newblock{\par}}%
}
\newif\ifutns@bibnumber
\DeclareOption{bibnumber}{\utns@bibnumbertrue%
  \def\utns@biblio{%
    \RequirePackage[sort&compress]{natbib}
    \bibpunct{[}{]}{,}{n}{}{,}%
    \def\@biblabel##1{##1.}%
    \bibliographystyle{plainnat}%
    \def\bibfont{\utns@bibliographyfont}%
    \setlength{\bibsep}{\z@}%
  }
}
\DeclareOption{bibauthoryear}{%
  \def\utns@biblio{%
    \RequirePackage{natbib}
    \bibpunct{(}{)}{;}{a}{}{,}%
    \def\bibfont{\utns@bibliographyfont}%
    \setlength{\bibsep}{\z@}%
  }%
}
\DeclareOption{bibyear}{%
  \def\utns@biblio{%
    \def\@biblabel##1{}%
    \def\@cite##1##2{{##1\if@tempswa , ##2\fi}}%
  }
}
\ExecuteOptions{a4paper,twocolumn,utf8,hideoverfull,bibauthoryear}
\ProcessOptions
\RequirePackage{calc}
\RequirePackage{etex}
\RequirePackage[T1]{fontenc}
\utns@inputenc
\utns@font
\ifutns@referee
\RequirePackage{xcolor}
\RequirePackage{marginnote}
\AtEndOfClass{
\setlength{\marginparwidth}{50mm}
\setlength{\marginparsep}{5mm}
}
%
\newcounter{lenote}
\AtBeginDocument{%
\@ifpackageloaded{hyperref}%
{\newcommand{\LEm}[1]{\texorpdfstring{\protect\stepcounter{lenote}{\normalfont\textbf{\color{red}[Note \arabic{lenote}] }}
\protect\marginnote{\baselineskip3ex{\normalsize{\normalfont\textbf{\color{red}[Note \arabic{lenote}: #1]}}}}}{}}
\newcommand{\LEt}[1]{\texorpdfstring{\protect\stepcounter{lenote}\normalfont\textbf{\color{red}[Note \arabic{lenote}: #1] }}{}}}%
{\newcommand{\LEm}[1]{\protect\stepcounter{lenote}{\normalfont\textbf{\color{red}[Note \arabic{lenote}] }}
\protect\marginnote{\baselineskip3ex{\normalsize{\normalfont\textbf{\color{red}[Note \arabic{lenote}: #1]}}}}}
\newcommand{\LEt}[1]{\protect\stepcounter{lenote}\normalfont\textbf{\color{red}[Note \arabic{lenote}: #1] }}}%
}
  \renewcommand*\utns@column{onecolumn}
  \utns@twocolumnfalse
  \setlength{\utns@fullwidth}{0.75\utns@fullwidth}
  \renewcommand*\utns@leftmarginpaper{15mm}
  \if!\csname longtab\endcsname!\AtEndDocument{\listofobjects}\fi
\fi
\ifx\pdfoutput\undefined
  \newcount\pdfoutput
\fi
\ifnum\pdfoutput=\z@
  \newcommand\utns@driver{dvips}
\else
  \newcommand\utns@driver{pdftex}
\fi
\RequirePackage[\utns@driver, \utns@paper, left=\utns@leftmarginpaper,
                \ifutns@twocolumn\utns@column\fi, \ifutns@referee\else twoside,\fi
                textheight=\utns@fullheight,headheight=12pt,headsep=12pt,
                footskip=20pt,
                textwidth=\utns@fullwidth, columnsep=5mm,
                marginpar=0in, marginparsep=0in]{geometry}
\RequirePackage{setspace}
\ifutns@referee
  \doublespacing
\fi
\RequirePackage{fancyhdr}
\RequirePackage{cuted}
\RequirePackage[tbtags,fleqn]{amsmath}
\RequirePackage{amssymb}
\setlength{\mathindent}{\z@}
\ifutns@letter
  \RequirePackage{xcolor}
\fi
\RequirePackage{url, enumerate}
\RequirePackage{longtable}
\renewcommand*\LT@makecaption[3]{%
  \LT@mcol\LT@cols
  c{\hbox to\z@{%
      \hss\parbox[t]\LTcapwidth{%
        \utns@longtablecaptionfont
        \sbox\@tempboxa{%
          #1{{\utns@longtableheadcaptionfont#2.} }#3%
        }%
        \ifdim\wd\@tempboxa>\hsize
          #1{{\utns@longtableheadcaptionfont#2.} }#3%
        \else
          \hbox to\hsize{\box\@tempboxa\hfil}%
        \fi
        \endgraf\vskip\baselineskip
      }%
      \hss
    }%
  }%
}
\utns@biblio
\RequirePackage{xspace}
\RequirePackage[english]{babel}
\renewenvironment{appendix}{\par
\def\@hangfrom##1{\setbox\@tempboxa\hbox{{##1}}%
      \hangindent \parindent\noindent\box\@tempboxa}
\def\sectcounterend{:}
\def\@seccntformat##1{\appendixname\ \csname the##1\endcsname\sectcounterend%
                      \hskip\betweenumberspace}
  \setcounter{section}{0}%
  \setcounter{subsection}{0}%
  \setcounter{figure}{0}%
  \setcounter{table}{0}%
  \renewcommand\thesection{\@Alph\c@section}%
  \renewcommand\thesubsection{\@Alph\c@section.\c@subsection}%
  \renewcommand\thesubsubsection{\thesubsection.\c@subsubsection}%
  \renewcommand\theequation{\@Alph\c@section.\@arabic\c@equation}%
  \renewcommand\thefigure{\@Alph\c@section.\@arabic\c@figure}%
  \renewcommand\thetable{\@Alph\c@section.\@arabic\c@table}%
  \@addtoreset{equation}{section}%
  \@addtoreset{figure}{section}%
  \@addtoreset{table}{section}}
{
  \setcounter{section}{0}%
  \setcounter{subsection}{0}%
  \setcounter{figure}{0}%
  \setcounter{table}{0}%
  \renewcommand\thesection{\c@section}%
  \renewcommand\thesubsection{\c@subsection}%
  \renewcommand\thesubsubsection{\c@subsubsection}%
  \renewcommand\theequation{\@arabic\c@equation}%
  \renewcommand\thefigure{\@arabic\c@figure}%
  \renewcommand\thetable{\@arabic\c@table}%
}
\RequirePackage[figuresright]{rotating}
\RequirePackage{answers}
\renewcommand{\Newassociation}[3]{%
   \newsolution{#2}%
   \expandafter\ifx\csname #3opentrue\endcsname\relax
      \expandafter\newif\csname if#3open\endcsname
   \fi
   \newenvironment{#1}{%
      \Ifanswerfiles{%
         \let\Tmp\relax
         \Iffileundefined{#3}{}{%
            \Ifopen{#3}{%
               \immediate\write\@nameuse{#3@file}%
                  {\string\begin{#2}\@nameuse{#2params}}%
            \def\Tmp{\Filesave{#3}}%
            }{}%
         }%
      }{%
         \edef\Tmp{\noexpand\begin{#2}\@nameuse{#2params}}%
      }%
      \csname pre#1\endcsname
      \Tmp
   }%
   {%
      \Ifanswerfiles{%
         \Iffileundefined{#3}{}{%
            \Ifopen{#3}{%
               \endFilesave%
               \immediate\write\@nameuse{#3@file}%
                  {\string\end{#2}}%
               \csname post#1\endcsname
            }{}%
         }%
      }{%
         \end{#2}%
      }%
   \stepcounter{table}}%
}
\renewcommand{\newsolution}[1]{%
   \@ifundefined{#1}{%
      \global\@namedef{#1params}{{\thetable}}%
      \newenvironment{#1}[1]%
      {%
         \csname pre#1\endcsname
         \trivlist
         \item[\hskip\itemsep{\@nameuse{#1label}{##1}}]}%
      {\csname post#1\endcsname\endtrivlist}%
      \global\@namedef{#1label}##1{\solutionstyle{##1}}%
   }{\typeout{WARNING: environment #1 already in use}}%
}
\renewcommand{\solutionextension}{llt}
\newcount\utns@cnta
\newcount\utns@cntb
\newcount\utns@nbwords
\newcount\utns@nbauthors
\newcount\utns@nbinstitutes
\newcommand*\utns@traditabstractmax{300}
\newcommand*\utns@structabstractmax{300}
\newcommand*\utns@keywordsmax{6}
\newcounter{utns@institutecnt}
\newcount\utns@savecounter
\newlength{\utns@dima}
\newlength{\utns@dimb}
\newlength{\utns@dimc}
\newcommand*\utns@removefootnoteindentspace{-1.5em}
\newcommand*\utns@removefootnotewbindentspace{-2.25em}
\newcommand*\utns@logoruleindent{8\p@}
\newcommand*\utns@logoruleraise{4\p@}
\newcommand*\utns@logorulelength{78\p@}
\newcommand*\utns@logorulethick{1\p@}
\newcommand*\utns@logoraise{25\p@}
\newcommand*\utns@logoraiserest{14.5\p@}
\newlength{\VSpaceBeforeTheorem}
\setlength{\VSpaceBeforeTheorem}{8\p@ \@plus 2\p@ \@minus 2\p@}
\newlength{\VSpaceAfterTheorem}
\setlength{\VSpaceAfterTheorem}{8\p@ \@plus 2\p@ \@minus 2\p@}
\newlength{\HSpaceIndentTheorem}
\setlength{\HSpaceIndentTheorem}{\z@}
\newlength{\HVSpaceSepTheorem}
\setlength{\HVSpaceSepTheorem}{0.25em}
\newlength{\utns@securityheadmargin}
\setlength{\utns@securityheadmargin}{2cm}
\newlength{\utns@bleedmargin}
\setlength{\utns@bleedmargin}{5mm}
\newlength{\utns@voffsetlettername}
\setlength{\utns@voffsetlettername}{2.55cm}
\newlength{\utns@hoffsetlettername}
\setlength{\utns@hoffsetlettername}{2mm}
\newlength{\utns@hoffsetgray}
\setlength{\utns@hoffsetgray}{1mm}
\newlength{\utns@aftercontentsnameskip}
\setlength{\utns@aftercontentsnameskip}{12\p@}
\newlength{\utns@aftercontentsAutnameskip}
\setlength{\utns@aftercontentsAutnameskip}{12\p@}
\newlength{\utns@beforeheadboxskip}
\setlength{\utns@beforeheadboxskip}{-20\p@}
\newlength{\utns@afterheadboxskip}
\setlength{\utns@afterheadboxskip}{0\p@}
\newlength{\utns@beforetopicsskip}
\setlength{\utns@beforetopicsskip}{18\p@}
\newlength{\utns@aftertopicsskip}
\setlength{\utns@aftertopicsskip}{32\p@}
\newlength{\utns@afterletternameskip}
\setlength{\utns@afterletternameskip}{6mm}
\newlength{\utns@beforeletternameskip}
\setlength{\utns@beforeletternameskip}{-4.8mm}
\newlength{\utns@beforeheadnoteskip}
\setlength{\utns@beforeheadnoteskip}{-12\p@}
\newlength{\utns@afterheadnoteskip}
\setlength{\utns@afterheadnoteskip}{3.5mm}
\newlength{\utns@aftertitleskip}
\setlength{\utns@aftertitleskip}{10\p@}
\newlength{\utns@beforesubtitleskip}
\setlength{\utns@beforesubtitleskip}{7\p@}
\newlength{\utns@aftersubtitleskip}
\setlength{\utns@aftersubtitleskip}{10\p@}
\newlength{\utns@afterauthorskip}
\setlength{\utns@afterauthorskip}{16.5\p@}
\newlength{\utns@beforernoteskip}
\setlength{\utns@beforernoteskip}{2pt}
\newlength{\utns@beforedefaultheadnoteskip}
\setlength{\utns@beforedefaultheadnoteskip}{2pt}
\newlength{\utns@headingleftmargin}
\setlength{\utns@headingleftmargin}{8mm}
\newlength{\utns@headingrightmargin}
\setlength{\utns@headingrightmargin}{8mm}
\newlength{\utns@afterinstituteskip}
\setlength{\utns@afterinstituteskip}{8\p@}
\newlength{\utns@instituteindent}
\newlength{\utns@afterdateskip}
\setlength{\utns@afterdateskip}{16.5\p@}
\newlength{\utns@afterdedicationskip}
\setlength{\utns@afterdedicationskip}{16.5\p@}
\newlength{\utns@afterabstractnameskip}
\setlength{\utns@afterabstractnameskip}{9\p@}
\newlength{\utns@afterabstractskip}
\setlength{\utns@afterabstractskip}{6\p@}
\newlength{\utns@aftersubabstractskip}
\setlength{\utns@aftersubabstractskip}{\z@}
\newlength{\utns@afterkeywordsskip}
\setlength{\utns@afterkeywordsskip}{24\p@}
\newlength{\utns@beforeacknowledgementsskip}
\setlength{\utns@beforeacknowledgementsskip}{6pt}
\newlength{\utns@afteracknowledgementsskip}
\setlength{\utns@afteracknowledgementsskip}{6pt}
\newlength{\utns@figgap}
\setlength{\utns@figgap}{12pt}
\newlength{\utns@sidecaptionminwidth}
\setlength{\utns@sidecaptionminwidth}{5cm}
\newlength{\utns@sidecaptionwidth}
\newlength{\VSpaceBeforeFigCaption}
\setlength{\VSpaceBeforeFigCaption}{5pt}
\newlength{\VSpaceAfterTabCaption}
\setlength{\VSpaceAfterTabCaption}{10pt}
\newlength{\VSpaceBeforeTabBib}
\setlength{\VSpaceBeforeTabBib}{2ex}
\newlength{\VSpaceBeforeTabFoot}
\setlength{\VSpaceBeforeTabFoot}{2ex}
\newlength{\utns@textonlineboxsep}
\setlength{\utns@textonlineboxsep}{1.5mm}
\newlength{\aftertext}
\setlength{\aftertext}{5pt}
\newlength{\utns@entryboxwidth}
\setlength{\utns@entryboxwidth}{8mm}
\newlength{\betweenumberspace}
\setlength{\betweenumberspace}{3.33pt}
\newif\ifutns@structabstract
\newif\ifutns@numberedtheorem
\newif\ifutns@rnoteedp
\newif\ifutns@firstonline
\utns@firstonlinetrue
\newcommand*\journalname[1]{\renewcommand*\utns@journalname{#1}}
\newcommand*\utns@journalname{UNIVERSITY THOUGHT}
\newcommand*\utns@manuscriptname{%
  \hspace{\stretch{1}}%
  doi: 156.135.1.tx
}
\def\Num{1}
\def\Vol{1}
\def\Month{JANUARY~I}
\newcommand*\AANum[1]{\renewcommand*\utns@numarticle{#1}%
\gdef\@AANum{#1}}
\newcommand*\@AANum{}
\newcommand*\utns@numarticle{}
\newcommand*\rnoteedp{\utns@rnoteedptrue}
\newcommand*\utns@pageof{\flushleft \bfseries \itshape PHYSICS}
\newcommand*{\utns@publishlink}{}
\newcommand*\utns@topicsname{}
\newcommand*\utns@offprintsname{}
\newcommand*\listobjectname{List of Objects}
\addto\captionsenglish{\renewcommand*\figurename{Figure.}}
\newcommand*\utns@figtype{figure}
\newcommand*\utns@tabtype{table}
\def\noteadd{\par\addvspace{17pt}\rm
\trivlist\item[\hskip\labelsep
{\it\noteaddname}]}
\def\endnoteadd{\endtrivlist\addvspace{6pt}}
\newcommand*\andname{\unskip, }
\newcommand*\andlastname{\unskip, and }
\newcommand*\andtwoname{\unskip\ and }
\newcommand*\etalname{et al.}
\newcommand*\utns@contentsname{Contents sorted by section}
\newcommand*\utns@contentsAutname{Contents sorted by first author}
\newcommand*\utns@pagename{page}
\newcommand*\utns@keywordname{Keywords}
\newcommand*\utns@acknowledgementsname{Acknowledgements}
\newcommand*\utns@floatcounterend{.~}
\newcommand*\utns@tablebibname{References}
\newcommand*\utns@tablefootname{Notes}
\newcommand\oneonlinepage[2]{%
  \def\reserved@a{#1}%
  \def\reserved@b{#2}%
  \let\reserved@c\reserved@a
  \ifx\r@LastPage\undefined\else
  \ifx\r@OLMFpage\undefined\else
    \expandafter\utns@extractpage\expandafter\@tempcnta\r@LastPage
    \expandafter\utns@extractpage\expandafter\@tempcntb\r@OLMFpage
    \ifnum\@tempcnta>\@tempcntb
      \let\reserved@c\reserved@b
    \fi
  \fi\fi
  \reserved@c
}
\newcommand*\utns@extractpage[6]{#1 #3\relax}
\renewcommand\normalsize{%
  \@setfontsize\normalsize\@xpt{11}%
  \abovedisplayskip 8.55\p@ \@plus4\p@ \@minus5\p@
  \abovedisplayshortskip \z@ \@plus3\p@
  \belowdisplayshortskip 6\p@ \@plus3\p@ \@minus3\p@
  \belowdisplayskip \abovedisplayskip
  \let\@listi\@listI}
\normalsize
\renewcommand\small{%
  \@setfontsize\small\@ixpt{10}%
  \abovedisplayskip 8.5\p@ \@plus3\p@ \@minus4\p@
  \abovedisplayshortskip \z@ \@plus2\p@
  \belowdisplayshortskip 4\p@ \@plus2\p@ \@minus2\p@
  \def\@listi{\leftmargin\leftmargini
    \parsep 0\p@ \@plus1\p@ \@minus1\p@
    \topsep 8\p@ \@plus2\p@ \@minus4\p@
    \itemsep0\p@}%
  \belowdisplayskip \abovedisplayskip
}
\let\footnotesize\small
\renewcommand\scriptsize{\@setfontsize\scriptsize\@viipt\@viiipt}
\renewcommand\tiny{\@setfontsize\tiny\@viiipt\@ixpt}
\renewcommand\large{\@setfontsize\large\@xipt{13}}
\renewcommand\Large{\@setfontsize\Large\@xivpt{16}}
\renewcommand\LARGE{\@setfontsize\LARGE\@xviipt{20}}
\renewcommand\huge{\@setfontsize\huge\@xxpt{24}}
\renewcommand\Huge{\@setfontsize\Huge\@xxvpt{30}}
\newcommand*\utns@headfont{\small}
\newcommand*\utns@footfont{\small}
\newcommand*\utns@subabstractfont{\normalsize\rmfamily\itshape}
\newcommand*\utns@abstractfont{\normalsize\bfseries}
\newcommand*\utns@offprintsnamefont{\itshape}
\newcommand*\utns@logo@astronomyfont{\fontsize{18}{21}\rmfamily\bfseries}
\newcommand*\utns@logo@andfont{\fontsize{16}{12}\rmfamily\mdseries}
\newcommand*\utns@logo@astrophysicsfont{\fontsize{18}{21}\rmfamily\bfseries}
\newcommand*\utns@letternamefont{\rmfamily\fontsize{19.2\p@}{21\p@}\bfseries}
\newcommand*\utns@headletternamefont{\large\scshape}
\newcommand*\utns@contentsnamefont{\Large\rmfamily\bfseries}
\newcommand*\utns@contentsAutnamefont{\Large\rmfamily\bfseries}
\newcommand*\utns@journalnamefont{\slshape}
\newcommand*\utns@manuscriptnamefont{}
\newcommand*\utns@todayheadboxfont{}
\newcommand*\utns@msnrheadboxfont{\LARGE\bfseries\smash}
\newcommand*\utns@textidlineempty{}
\newcommand*\utns@idlinefont{}
\newcommand*\utns@doifont{}
\newcommand*\utns@copyrightfont{\small}
\ifutns@letter
  \definecolor{utns@colorletter}{gray}{0.6}
\fi
\newcommand*\utns@topicsfont{\fontsize{12}{14}\rmfamily\itshape}
\newcommand*\utns@topicsnamefont{\fontsize{17}{20}\rmfamily}
\newcommand*\utns@headnotefont{\LARGE\itshape}
\newcommand*\utns@defaultheadnotefont{\LARGE\rmfamily\bfseries\itshape}
\newcommand*\utns@titlefont{\Large\rmfamily\bfseries\boldmath\flushleft\leftskip 25pt\rightskip 25pt}
\newcommand*\utns@subtitlefont{\Large\rmfamily\bfseries\boldmath}
\newcommand*\utns@rnotefont{\LARGE \rmfamily\bfseries\itshape}
\newcommand*\utns@rnotfont{\itshape}
\newcommand*\utns@authorfont{\normalfont\bfseries\flushleft\leftskip 25pt \rightskip 25pt}
\newcommand*\utns@institutefont{\small}
\newcommand*\utns@datefont{\small}
\newcommand*\utns@dedicationfont{\itshape}
\newcommand*\utns@abstractnamefont{\small\rmfamily\bfseries\MakeUppercase}
\newcommand*\utns@keywordnamefont{\normalfont\rmfamily\bfseries}
\newcommand*\utns@keywordfont{\normalfont\bfseries}
\newcommand*\utns@longauthfont{\centering\small\itshape}
\newcommand*\utns@longauthname{Affiliations can be found after the references}
\newcommand*\utns@longauthopen{(}
\newcommand*\utns@longauthclose{)}
\newcommand*\utns@acknowledgementsfont{\tiny}
\newcommand*\utns@acknowledgementsnamefont{\itshape}
\newcommand*\utns@bibliographyfont{\normalfont}
\newcommand*\utns@captionfont{\normalfont\small}
\newcommand*\utns@headcaptionfont{\bfseries}
\newcommand*\utns@tablebibfont{\small}
\newcommand*\utns@tablebibnamefont{\small\bfseries}
\newcommand*\utns@tablefootfont{\small}
\newcommand*\utns@tablefootnamefont{\small\bfseries}
\newcommand*\utns@descriptionlabelfont{}
\newcommand\utns@longtablecaptionfont{\small}
\newcommand\utns@longtableheadcaptionfont{\small\bfseries}
\newcommand*\utns@textonlineboxfont{\rmfamily}
\newcommand*\utns@emailfont{\ttfamily}
\newcommand*\utns@entryifont{\itshape}
\newcommand*\utns@entryiifont{\bfseries}
\newbox\utns@stripbox
\newbox\utns@outputbox
\newenvironment{utns@strip}
{%
  \onecolumn
  \setbox\utns@stripbox=\vbox\bgroup
}
{%
  \egroup
  \utns@@strip
}
\def\utns@@strip{%
  \ifdim\ht\utns@stripbox>\textheight
    \global\setbox\utns@outputbox=\vsplit\utns@stripbox to \textheight
    \dp\utns@outputbox \z@
    \box\utns@outputbox\clearpage
    \expandafter\utns@@strip
  \else
    \dp\utns@stripbox \z@
    \twocolumn[\box\utns@stripbox]
  \fi
}
\newcommand{\ErratumOf}[3][]{}
\newcommand{\NoteFor}[3][]{}
\renewcommand*\@fnsymbol[1]{%
  \ensuremath{%
    \ifcase#1
    \or\star
    \or{\star}{\star}
    \or{\star}{\star}{\star}%
    \or{\star}{\star}{\star}{\star}
    \or \dagger
    \or \ddagger
    \or \mathsection
    \or \mathparagraph
    \or \|
    \or **
    \or \dagger\dagger
    \or \ddagger\ddagger
    \else \@ctrerr
    \fi
  }%
}
\newcommand\longempty{}
\newcommand*\utns@cntwords[1]{%
  \protected@edef\utns@cntwords@arg{#1\space\noexpand\utns@nil\space}%
  \utns@nbwords \z@
  \let\@@protect\protect
  \let\protect\@unexpandable@protect
  \expandafter\utns@@cntwords\utns@cntwords@arg
  \restore@protect
}
\newcommand*\utns@nnil{\utns@nil}
\long\def\utns@@cntwords#1 {%
  \def\utns@arg{#1}%
  \ifx\utns@arg\utns@nnil
  \else
    \advance\utns@nbwords \@ne
    \expandafter\utns@@cntwords
  \fi
}
\newcommand*\utns@roheadletter{%
  \setlength{\utns@dima}
            {1in + \topmargin + \headheight - \dp\strutbox +
              \utns@bleedmargin}%
  \setlength{\utns@dimb}
            {\paperwidth - (1in + \oddsidemargin + \textwidth) +
              \utns@bleedmargin - \utns@hoffsetgray}%
  \setbox0=\hbox{\utns@letternamefont \lettername}%
  \setlength{\utns@dimc}
            {\paperheight - \utns@dima - \wd0 + 2\utns@bleedmargin}%
  \leavevmode
  \hbox to0pt{%
    \hspace*{\utns@hoffsetgray}%
    \vbox to0pt{%
      \hsize=\utns@dimb
      \vskip-\utns@dima
      \colorbox{utns@colorletter}{%
        \vtop{%
          \vspace*{\utns@voffsetlettername}%
          \hspace*{\utns@hoffsetlettername}%
          \rotatebox{90}{\utns@letternamefont \lettername}%
          \hfill\null
          \vspace*{\utns@dimc}%
        }%
      }%
      \vss
    }%
    \hss
  }%
}
\newcommand*\utns@leheadletter{%
  \setlength{\utns@dima}
            {1in + \topmargin + \headheight - \dp\strutbox +
              \utns@bleedmargin}%
  \setlength{\utns@dimb}
            {1in + \oddsidemargin + \utns@bleedmargin - \utns@hoffsetgray}%
  \setbox0=\hbox{\utns@letternamefont \lettername}%
  \setlength{\utns@dimc}
            {\paperheight-\utns@dima-\wd0+2\utns@bleedmargin}%
  \leavevmode
  \hspace*{-2\fboxsep}%
  \hbox to0pt{%
    \hss
    \vbox to0pt{%
      \hsize=\utns@dimb
      \vskip-\utns@dima
      \colorbox{utns@colorletter}{%
        \vtop{%
          \vspace*{\utns@voffsetlettername}%
          \hfill
          \rotatebox{90}{\utns@letternamefont \lettername}%
          \hspace*{\utns@hoffsetlettername}%
          \vspace*{\utns@dimc}%
        }%
      }%
      \vss
    }%
    \hspace*{\utns@hoffsetgray}%
  }%
}
\ifutns@online
  \fancypagestyle{firstpage}{%
    \fancyhf{}%
    \renewcommand*{\headrulewidth}{\z@}%
    \renewcommand*{\footrulewidth}{\z@}%
    \fancyfoot[RO]{\utns@footfont\utns@publishlink\utns@numarticle\utns@pageof}%
    \fancyfoot[LE]{\utns@footfont\utns@numarticle\utns@pageof\qquad\utns@publishlink}%
  }
\else
  \fancypagestyle{firstpage}{%
    \fancyhf{}%
    \renewcommand*{\headrulewidth}{\z@}%
    \renewcommand*{\footrulewidth}{\z@}%
    \fancyfoot[RO]{\utns@footfont \utns@numarticle\utns@pageof}%
    \fancyfoot[LE]{\utns@footfont \utns@numarticle\utns@pageof}%
  }
\fi
\ifutns@contents
  \fancypagestyle{otherpage}{%
    \fancyhf{}%
    \fancyhead[C]{\utns@AAname}%
    \fancyfoot[C]{\utns@contentsname, \utns@pagename\space \thepage}%
    \renewcommand*{\headrulewidth}{\z@}%
    \renewcommand*{\footrulewidth}{\z@}%
  }
\else\ifutns@contentsAut
  \fancypagestyle{otherpage}{%
    \fancyhf{}%
    \fancyhead[C]{\utns@AAname}%
    \fancyfoot[C]{\utns@contentsAutname, \utns@pagename\space \thepage}%
    \renewcommand*{\headrulewidth}{\z@}%
    \renewcommand*{\footrulewidth}{\z@}%
  }
\else
  \fancypagestyle{otherpage}{%
    \fancyhf{}%
    \fancyhead[CO]{\utns@headfont \utns@headings}%
    \fancyhead[CE]{\utns@headfont \ifx\utns@idline\empty\utns@textidlineempty\else\utns@idline\fi}%
    \fancyfoot[RO]{\utns@footfont \utns@numarticle\utns@pageof}%
    \fancyfoot[LE]{\utns@footfont \utns@numarticle\utns@pageof}%
    \renewcommand*{\headrulewidth}{\z@}%
    \renewcommand*{\footrulewidth}{\z@}%
  }
\fi\fi
\pagestyle{otherpage}
\newcommand*\utns@headings{}
\renewcommand*\date[1]{\renewcommand*\utns@date{#1}}%
\newcommand*\utns@date{}
\renewcommand*\title[1]{\renewcommand*\utns@title{#1}}%
\newcommand*\utns@title{}
\newcommand*\subtitle[1]{\renewcommand*\utns@subtitle{#1}}
\newcommand*\utns@subtitle{}
\renewcommand*\author[1]{%
  \renewcommand*\utns@author{#1}%
  \begingroup
    \let\and\relax
    \renewcommand*\inst[1]{}%
    \renewcommand*\thanks[1]{}%
    \renewcommand*\email[1]{}%
    \let\@@protect\protect
    \let\protect\@unexpandable@protect
    \global\utns@nbauthors \z@
    \expandafter\utns@cntauthors\utns@author\and\utns@nil\and
    \restore@protect
  \endgroup
}%
\newcommand*\utns@author{}
\def\utns@cntauthors#1\and{%
  \def\utns@arg{#1}%
  \ifx\utns@arg\utns@nnil
  \else
    \global\advance\utns@nbauthors \@ne
    \expandafter\utns@cntauthors
  \fi
}
\newcommand*\institute[1]{%
  \renewcommand*\utns@institute{#1}
  \begingroup
    \let\and\relax
    \renewcommand*\inst[1]{}%
    \renewcommand*\thanks[1]{}%
    \renewcommand*\email[1]{}%
    \let\@@protect\protect
    \let\protect\@unexpandable@protect
    \global\utns@nbinstitutes \z@
    \expandafter\utns@cntinstitutes\utns@institute\and\utns@nil\and
    \restore@protect
  \endgroup
}%
\newcommand*\utns@institute{}
\def\utns@cntinstitutes#1\and{%
  \def\utns@arg{#1}%
  \ifx\utns@arg\utns@nnil
  \else
    \global\advance\utns@nbinstitutes \@ne
    \expandafter\utns@cntinstitutes
  \fi
}
\newcommand*\inst[1]{\unskip\hbox{\@textsuperscript{\normalfont$#1$}}}
\newcommand*\fnmsep{\unskip\hbox{\@textsuperscript{\normalfont,}}}
\newcommand*\email[1]{e-mail: {\utns@emailfont #1}}
\let\endabstract\relax
\renewcommand\abstract[1]{%
  \renewcommand\utns@abstract@i{#1}%
  \@ifnextchar\bgroup{\utns@abstract@next}{\utns@abstract@one}
}
\newcommand\utns@abstract@next[4]{%
  \utns@structabstracttrue
  \renewcommand\utns@abstract@ii{#1}%
  \renewcommand\utns@abstract@iii{#2}%
  \renewcommand\utns@abstract@iv{#3}%
  \renewcommand\utns@abstract@v{#4}%
  \begingroup
    \renewcommand\thanks[1]{}%
    \protected@xdef\utns@abstractwords{%
    }%
  \endgroup
  \utns@cnta \z@
  \utns@cntb \utns@structabstractmax
  \utns@abstract@cnt
}
\newcommand*\utns@abstract@one{%
  \protected@xdef\utns@abstractwords{\utns@abstract@i}%
  \utns@cnta \z@
  \utns@cntb \utns@traditabstractmax
  \utns@abstract@cnt
}
\def\utns@abstract@cnt{%
  \utns@cntwords\utns@abstractwords
  \advance\utns@nbwords \utns@cnta\relax
  \ifnum\utns@nbwords>\utns@cntb
  \typeout{^^J^^J!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
    \ClassWarning{utns}
      {Around \the\utns@nbwords\space words in the abstract instead
        of \the\utns@cntb\space (max). You should rewrite your abstract}
  \typeout{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  ^^J}
  \fi
}
\newcommand\utns@abstract@i{}
\newcommand\utns@abstract@ii{}
\newcommand\utns@abstract@iii{}
\newcommand\utns@abstract@iv{}
\newcommand\utns@abstract@v{}
\newcommand*\keywords[1]{%
  \renewcommand*\utns@keywords{#1}%
  \utns@keywords@cnt
  \ifnum\utns@nbwords>\utns@keywordsmax
    \ClassWarning{utns}
      {\the\utns@nbwords\space keywords instead of a maximum of
        \utns@keywordsmax\space}
  \fi
}
\newcommand*\utns@keywords{}
\newcommand*\utns@doublehyphen{--}
\newcommand*\utns@keywords@cnt{%
  \protected@edef\utns@@keywords{\utns@keywords--\noexpand\utns@nil--}%
  \utns@nbwords \z@
  \let\@@protect\protect
  \let\protect\@unexpandable@protect
  \expandafter\utns@@keywords@cnt\utns@@keywords
  \restore@protect
}
\def\utns@@keywords@cnt#1--{%
  \def\utns@arg{#1}%
  \ifx\utns@arg\utns@nnil
  \else
    \advance\utns@nbwords \@ne
    \expandafter\utns@@keywords@cnt
  \fi
}
\newcommand*\topics[1]{\renewcommand*\utns@topics{}}
\newcommand*\utns@topics{}
\newcommand*\titlerunning[1]{%
  \renewcommand*\utns@titlerunning{}
}
\newcommand*\utns@titlerunning{}
\newcommand*\authorrunning[1]{%
  \renewcommand*\utns@authorrunning{}
}
\newcommand*\utns@authorrunning{}
\newcommand*\offprints[1]{%
  \protected@edef\@thanks{%
    \@thanks
    \protect\footnotetext[0]{%
      \unskip%
      \if@wideboxfn%
        \hspace{\utns@removefootnotewbindentspace}%
      \else%
        \hspace{\utns@removefootnoteindentspace}%
      \fi
      {%
        \utns@offprintsnamefont
        \utns@offprintsname
      }: \ignorespaces#1%
    }%
  }%
}
\def\utnsinstitutename{\par
  \begingroup
  \renewcommand*\and{%
      \par\refstepcounter{utns@institutecnt}%
      \hangindent\utns@instituteindent
      \noindent
      \hbox to\utns@instituteindent{%
        \hss
        \hbox{\@textsuperscript{\normalfont\theutns@institutecnt}}%
        \enspace
      }%
      \ignorespaces
    }%
    \ifnum\utns@nbinstitutes>99
      \setbox0=\hbox{\hbox{\@textsuperscript{\normalfont888}}\enspace}%
    \else\ifnum\utns@nbinstitutes>9
      \setbox0=\hbox{\hbox{\@textsuperscript{\normalfont88}}\enspace}%
    \else
      \setbox0=\hbox{\hbox{\@textsuperscript{\normalfont8}}\enspace}%
    \fi\fi
    \utns@instituteindent \wd0
    {%
      \utns@institutefont
      \par\refstepcounter{utns@institutecnt}%
      \ifnum\utns@nbinstitutes=1\relax
      \noindent\ignorespaces
      \else
        \hangindent\utns@instituteindent
        \noindent
        \hbox to\utns@instituteindent{%
          \hss
          \hbox{\@textsuperscript{\normalfont\theutns@institutecnt}}%
          \enspace
        }\ignorespaces%
      \fi%
      \utns@institute\par
    }
  \endgroup}
\newcommand*\mail[1]{\renewcommand*\utns@mail{#1}}
\newcommand*\utns@mail{}
\newcommand*\msnr[1]{\renewcommand*\utns@msnr{#1}}
\newcommand*\utns@msnr{}
\newcommand*\idline[1]{\renewcommand*\utns@idline{#1}}
\newcommand*\utns@idline{}
\newcommand*\headnote[1]{\renewcommand*\utns@headnote{#1}}
\newcommand*\utns@headnote{}
\newcommand*\utns@defaultheadnote{Corrigendum}
\newcommand*\dedication[1]{\renewcommand*\utns@dedication{#1}}
\newcommand*\utns@dedication{}
\renewcommand*\maketitle{%
  \thispagestyle{firstpage}
  \ifutns@twocolumn
  \begingroup
    \if@wideboxfn
    \setlength\bibindent{1.4\parindent}
    \else
    \setlength\bibindent{\parindent}
    \fi
    \renewcommand*\thefootnote{\@fnsymbol\c@footnote}%
    \renewcommand\@makefntext[1]{%
    \ifutns@longfn\hsize\textwidth\fi
    \noindent
    \hb@xt@\bibindent{\hss\@makefnmark\enspace}##1}
    \twocolumn[\utns@maketitle]
    \@thanks
  \endgroup
  \else
    \begingroup
      \renewcommand*\thefootnote{\@fnsymbol\c@footnote}%
      \renewcommand*\@makefnmark{%
        \rlap{\@textsuperscript{\normalfont\@thefnmark}}%
      }%
      \renewcommand\@makefntext[1]{%
        \parindent 1em
        \noindent
        \hb@xt@\bibindent{%
          \hss\@textsuperscript{\normalfont\@thefnmark}%
        }%
        ##1%
      }%
      \let\thanks\footnote
      \utns@maketitle
    \endgroup
  \fi
  \setcounter{footnote}{0}%
}
\newcommand*\utns@maketitle{%
  \ifutns@contents
    {\utns@contentsnamefont \utns@contentsname\par}
    \addvspace{\utns@aftercontentsnameskip}
  \else\ifutns@contentsAut
    {\utns@contentsAutnamefont \utns@contentsAutname\par}
    \addvspace{\utns@aftercontentsAutnameskip}
  \else
    \vbox to0pt{\vskip\utns@beforeheadboxskip
    \nointerlineskip
  \ifx\utns@idline\empty
    \noindent
%    \fbox{%
      \begin{minipage}{\linewidth-2\fboxsep-2\fboxrule}
        \strut
        {\utns@todayheadboxfont \utns@journalname}
        {\utns@manuscriptnamefont \utns@manuscriptname}\\
        \ifx\utns@msnr\empty
          {\strut\utns@todayheadboxfont Publication in Natural Science and Mathematics, Vol.-, No.-, 2018, pp. 1-5 \hspace{\stretch{1}} Research Article}%
        \else
          \makebox[0.75\linewidth][r]{%
            \strut
            {\utns@msnrheadboxfont \utns@msnr}%
          }%
        \fi
      \end{minipage}%
 %   }%
  \else
    \begin{tabular}[b]{@{}l@{}}
      \utns@idlinefont \utns@idline\\
      \utns@doifont \utns@doi\\
      \utns@copyrightfont \utns@copyrightname~\the\year
    \end{tabular}
    \hfill\AALogo
  \fi\vss}
  \par
  \ifx\utns@topics\empty%
    \addvspace{\utns@afterheadboxskip}
  \else
    \addvspace{\utns@beforetopicsskip}
    {\noindent\utns@topicsfont \utns@topics}%
    \hfill
    {\utns@topicsnamefont \utns@topicsname\par}
    \addvspace{\utns@aftertopicsskip}
  \fi
  \begingroup
    \centering
    \ifutns@letter
      \ifx\utns@topics\empty
      \addvspace{1.8\utns@beforeletternameskip}
      \else
      \addvspace{\utns@beforeletternameskip}
      \fi
      {\utns@headletternamefont \lettername\par}
      \addvspace{\utns@afterletternameskip}
    \fi
    \ifx\utns@headnote\empty\else
      \ifx\utns@headnote\utns@defaultheadnote\else
        {\utns@headnotefont \utns@headnote\par}
        \addvspace{\utns@afterheadnoteskip}
      \fi
    \fi
    {\utns@titlefont \utns@title\par}
    \ifx\utns@subtitle\empty%
      \ifutns@rnote
        {\utns@rnotefont \rnotename\par}
      \fi
      \ifx\utns@headnote\utns@defaultheadnote
        {\utns@defaultheadnotefont (\utns@headnote)\par}
      \fi
    \addvspace{\utns@aftertitleskip}
    \else
    \addvspace{\utns@aftertitleskip}
      {\utns@subtitlefont \utns@subtitle\par}
      \ifutns@rnote
        \addvspace{\utns@beforernoteskip}
        {\utns@rnotefont \rnotename\par}
      \fi
      \ifx\utns@headnote\utns@defaultheadnote
        \addvspace{\utns@beforedefaultheadnoteskip}
        {\utns@defaultheadnotefont (\utns@headnote)\par}
      \fi
      \addvspace{\utns@aftersubtitleskip}
    \fi
    \ifnum\utns@nbauthors=\tw@
      \let\and\andtwoname
    \else
      \renewcommand\and{%
        \advance\utns@cnta \@ne
        \ifnum\utns@cnta=\utns@nbauthors
          \andlastname
        \else
          \andname
        \fi
      }
    \fi
    \utns@cnta \@ne
    {\utns@authorfont \utns@author\par}
    \addvspace{\utns@afterauthorskip}
  \endgroup
  \begingroup
    \leftskip \utns@headingleftmargin
    \rightskip \utns@headingrightmargin
    \ifutns@longauth
      {\noindent\utns@longauthfont%
       \utns@longauthopen\utns@longauthname\utns@longauthclose\par}
    \else
      \utnsinstitutename
    \fi
    \vspace{\utns@afterinstituteskip}
    {\noindent\utns@datefont\ifutns@longauth\centering\fi \utns@date\par}
    \ifx\utns@dedication\empty
      \vspace{\utns@afterdateskip}
    \else
    \addvspace\baselineskip
      {\noindent\utns@dedicationfont \utns@dedication\par}
      \vspace{\utns@afterdedicationskip}
    \fi
    {\utns@abstractnamefont \abstractname\par}
    \vspace{\utns@afterabstractnameskip}
    \ifutns@structabstract
      \ifx\utns@abstract@i\longempty\else
        {\noindent\utns@subabstractfont \utns@subabstractiname. }%
        {\utns@abstractfont \ignorespaces\utns@abstract@i\par}
        \vspace{\utns@aftersubabstractskip}
      \fi
      {\noindent\utns@subabstractfont \utns@subabstractiiname. }%
      {\utns@abstractfont \ignorespaces\utns@abstract@ii\par}
      \vspace{\utns@aftersubabstractskip}
      {\noindent\utns@subabstractfont \utns@subabstractiiiname. }%
      {\utns@abstractfont \ignorespaces\utns@abstract@iii\par}
      \vspace{\utns@aftersubabstractskip}
      {\noindent\utns@subabstractfont \utns@subabstractivname. }%
      {\utns@abstractfont \ignorespaces\utns@abstract@iv\par}
      \vspace{\utns@aftersubabstractskip}
      \ifx\utns@abstract@v\longempty\else
        {\noindent\utns@subabstractfont \utns@subabstractvname. }%
        {\utns@abstractfont \ignorespaces\utns@abstract@v\par}
      \fi
    \else
      {\noindent\utns@abstractfont \ignorespaces\utns@abstract@i\par}
    \fi
    \vspace{\utns@afterabstractskip}
    \ifx\utns@keywords\empty\else
      \noindent
      {\utns@keywordnamefont \utns@keywordname. }
      {\utns@keywordfont \ignorespaces\utns@keywords\par}
      \vspace{\utns@afterkeywordsskip}
    \fi
  \endgroup
  \renewcommand*\thanks[1]{}%
  \renewcommand*\inst[1]{}%
  \renewcommand*\fnmsep{}%
  \renewcommand*\and{, }%
  \renewcommand*\\{ }%
  \protected@xdef\utns@PDFauthor{\utns@author}%
  \protected@xdef\utns@PDFtitle{\noexpand\protect\noexpand\utns@title}%
  \def\object##1{##1}%
  \ifx\utns@authorrunning\empty
    \let\and\relax
    \renewcommand*\\{\unskip\space\ignorespaces}%
    \ifnum\utns@nbauthors=1
      \expandafter\utns@extractoneauthor\utns@author\and\utns@nil
    \else\ifnum\utns@nbauthors=2
      \expandafter\utns@extracttwoauthor\utns@author\and\utns@nil
    \else
      \expandafter\utns@extractoneauthor\utns@author\and\utns@nil
      \protected@xdef\utns@headings{}%
    \fi\fi
  \else
    \xdef\utns@headings{ }%
  \fi
  \ifx\utns@titlerunning\empty
    \protected@xdef\utns@headings{}%
  \else
    \protected@xdef\utns@headings{}%
  \fi
  \ifutns@rnote
    \protected@xdef\utns@headings{%
      \utns@headings\space
      \utns@rnotfont \rnotname
    }%
  \fi
  \setbox0=\hbox{%
    \hspace*{\utns@securityheadmargin}%
    \utns@headfont \utns@headings
  }%
  \ifdim\wd0>\utns@fullwidth
    \typeout{^^J^^J!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
    \ClassWarning{utns}
               {The running head built automatically
                 from \string\author\space and \string\title
                 exceeds the pagewidth, please supply a shorter form
                 with \string\authorrunning\space and/or
                 \string\titlerunning\space prior to \string\maketitle}
               {Use \string\titlerunning\space to supply a shorter
                 title and/or \string\authorrunning\space to supply a
                 shorter list of authors.}%
    \typeout{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    ^^J}
  \fi
  \fi\fi
}
\def\utns@extractoneauthor#1\and#2\utns@nil{%
  \gdef\utns@headings{#1}%
}
\def\utns@extracttwoauthor#1\and#2\and#3\utns@nil{%
  \gdef\utns@headings{#1\andtwoname#2}%
}
\def\sectcounterend{.}
\def\@seccntformat#1{\csname the#1\endcsname\sectcounterend
\hskip\betweenumberspace}
\def\@sect#1#2#3#4#5#6[#7]#8{%
  \ifnum #2>\c@secnumdepth
    \let\@svsec\@empty
  \else
    \refstepcounter{#1}%
    \protected@edef\@svsec{\@seccntformat{#1}\relax}%
  \fi
  \@tempskipa #5\relax
  \ifdim \@tempskipa>\z@
    \begingroup
      #6{%
        \@hangfrom{\hskip #3\relax\@svsec}%
          \raggedright
          \hyphenpenalty \@M%
          \interlinepenalty \@M #8\@@par}%
    \endgroup
    \csname #1mark\endcsname{#7}%
    \addcontentsline{toc}{#1}{%
      \ifnum #2>\c@secnumdepth \else
        \protect\numberline{\csname the#1\endcsname}%
      \fi
      #7}%
  \else
    \def\@svsechd{%
      #6{\hskip #3\relax
      \@svsec #8\hskip\aftertext}%
      \csname #1mark\endcsname{#7}%
      \addcontentsline{toc}{#1}{%
        \ifnum #2>\c@secnumdepth \else
          \protect\numberline{\csname the#1\endcsname}%
        \fi
        #7}}%
  \fi
  \@xsect{#5}}
\ifutns@contentsAut
  \renewcommand\section{%
    \@startsection{section}
                  {1}
                  {\z@}
                  {-16dd \@plus-4\p@ \@minus-4\p@}
                  {6dd}
                  {\normalsize\bfseries\boldmath\MakeUppercase}%
  }
\else\ifutns@contents
  \renewcommand\section{%
    \@startsection{section}
                  {1}
                  {\z@}
                  {-16dd \@plus-4\p@ \@minus-4\p@}
                  {6dd}
                  {\normalsize\bfseries\boldmath\MakeUppercase}%
  }
\else
  \renewcommand\section{%
    \@startsection{section}
                  {1}
                  {\z@}
                  {-16dd\@plus-4\p@ \@minus-4\p@}
                  {6dd}
                  {\normalsize\rmfamily\bfseries\boldmath}%
  }
\fi\fi
\renewcommand\subsection{%
  \@startsection{subsection}
                {2}
                {\z@}
                {-16dd}
                {6dd}
                {\normalsize\rmfamily\itshape}%
}
\renewcommand\subsubsection{%
  \@startsection{subsubsection}
                {3}
                {\z@}
                {-16dd}
                {6dd}
                {\normalsize\rmfamily}%
}
\renewcommand\paragraph{%
  \@startsection{paragraph}
                {4}
                {\z@}
                {-16dd}
                {-\fontdimen2\font
                  \@plus-\fontdimen3\font
                  \@minus-\fontdimen4\font}
                {\normalsize\rmfamily}%
}
\renewcommand\subparagraph{%
  \ClassError{utns}{Command \string\subparagrap\space isn't allowed}
                          {Only commands from \string\section\space to
                            \string\paragraph\space are allowed.}
}
\renewcommand\part{%
  \ClassError{utns}{Command \string\part\space isn't allowed}
                          {Only commands from \string\section\space to
                            \string\paragraph\space are allowed.}
}
\frenchspacing
\clubpenalty=10000
\widowpenalty=10000
\flushbottom
\ifutns@twocolumn
  \sloppy
\fi
\newenvironment{nopar}
  {\let\par\relax%
    \utns@acknowledgementsfont
      {%
        \noindent\utns@acknowledgementsnamefont
        \utns@acknowledgementsname.%
      }%
  \hskip.5em
  }{}
\newenvironment{acknowledgements}
  {%
   \par\addvspace{\utns@beforeacknowledgementsskip}
   \begin{spacing}{0.81}
   \begin{nopar}
  }
  {%
   \end{nopar}
   \end{spacing}
   \addvspace{\utns@afteracknowledgementsskip}
  }
\let\acknowledgement\acknowledgements
\let\endacknowledgement\endacknowledgements
\renewcommand\@makefntext[1]{%
    \noindent
    \hb@xt@\bibindent{\hss\@makefnmark\enspace}#1}
\newcommand\listofobjects{%
  \section*{\listobjectname}
  \@starttoc{obj}%
}
\newcommand*\l@obj[2]{\noindent`#1' on page #2\par}
\DeclareRobustCommand{\object}[1]{%
   #1%
   \addcontentsline{obj}{obj}{#1}%
}
\newcommand\Online{%
  \ifutns@online\else\utns@onlinetrue
  \def\ps@Onlheadings{%
    \let\@oddfoot\@empty\let\@evenfoot\@empty
    \def\@evenhead{\hfil A\&A--\jobname, {\it Online Material p~\thepage}\hfil}%
    \def\@oddhead{\hfil A\&A--\jobname, {\it Online Material p~\thepage}\hfil}%
    \let\@mkboth\@gobbletwo
    \let\sectionmark\@gobble
    \let\subsectionmark\@gobble
  }
  \clearpage
  \pagestyle{Onlheadings}
  \fi
}
\newcommand*\utns@displaytextonlinebox[1]{%
  \begingroup
    \fboxsep=\utns@textonlineboxsep
    \fbox{%
      \parbox{\linewidth-\utns@textonlineboxsep}{%
        \centering
        \utns@textonlineboxfont
        #1%
      }%
    }%
  \endgroup
}
\newcommand\onlfig{%
  \onlfloat{figure}%
}
\newcommand\onltab{%
  \onlfloat{table}%
}
\newcommand\onllongtab{%
  \onllongfloat{table}%
}
\newcommand\onlfloat[2]{%
  \AtEndDocument{%
    \Online
    \utns@savecounter \csname c@#1\endcsname \relax
    \csname c@#1\endcsname
  }%
  \edef\utns@nombre{\number\csname c@#1\endcsname}%
  \expandafter\AtEndDocument\expandafter{%
    \utns@nombre\relax
    #2%
    \csname c@#1\endcsname \utns@savecounter \relax
  }%
  \stepcounter{#1}%
}
\newcommand\onllongfloat[2]{%
  \AtEndDocument{%
    \Online
    \utns@savecounter \csname c@#1\endcsname \relax
    \csname c@#1\endcsname
  }%
  \edef\utns@nombre{\number\csname c@#1\endcsname}%
  \expandafter\AtEndDocument\expandafter{%
    \utns@nombre\relax
    \setlength{\LTcapwidth}{\textwidth}
    \onecolumn
    #2%
    \twocolumn
    \csname c@#1\endcsname \utns@savecounter \relax
  }%
  \stepcounter{#1}%
}
\Newassociation{longtab}{Longtab}{\jobname}
\newcommand{\Debutlongtab}{\Opensolutionfile{\jobname}}
\newcommand{\Finlongtab}{\Closesolutionfile{\jobname} \Ecrirelongtab }
\newcommand{\Ecrirelongtab}{  \Readsolutionfile{\jobname}}
\renewenvironment{Longtab}[1]{\setcounter{table}{#1}%
  \setlength{\LTcapwidth}{\textwidth}%
  \onecolumn}{%
  \twocolumn%
}
\g@addto@macro{\maketitle}{\Debutlongtab}
\renewcommand*\enddocument{%
   \let\AtEndDocument\@firstofone
   \@enddocumenthook
   \clearpage
   \advance\c@page \m@ne
   \immediate\write\@auxout{\string\newlabel{LastPage}{{\thepage}{\thepage}{}{}{}}}
   \@checkend{document}%
   \clearpage
   \begingroup
     \if@filesw
       \immediate\closeout\@mainaux
       \let\@setckpt\@gobbletwo
       \let\@newl@bel\@testdef
       \@tempswafalse
       \makeatletter \input\jobname.aux
     \fi
     \@dofilelist
     \ifdim \font@submax >\fontsubfuzz\relax
       \@font@warning{Size substitutions with differences\MessageBreak
                  up to \font@submax\space have occurred.\@gobbletwo}%
     \fi
     \@defaultsubs
     \@refundefined
     \if@filesw
       \ifx \@multiplelabels \relax
         \if@tempswa
           \@latex@warning@no@line{Label(s) may have changed.
               Rerun to get cross-references right}%
         \fi
       \else
         \@multiplelabels
       \fi
     \fi
   \endgroup
   \deadcycles\z@\@@end}
\newcommand*\utns@defineentry{%
  \newcommand{\entry}[3]{%
    \par\noindent
    {\utns@entryiifont ##2}%
    \par
    {%
      \noindent
      \raggedright
      {\utns@entryifont ##1}%
      \hfill
      \rlap{\makebox[\utns@entryboxwidth][l]{\hfill##3}}%
      \par
    }%
    \vspace{\aftertext}
  }
}
\ifutns@contents \utns@defineentry \fi
\ifutns@contentsAut \utns@defineentry \fi
\renewcommand\@listi{%
  \leftmargin \leftmargini
  \parsep \z@ \@plus\p@ \@minus\p@
  \topsep 8\p@ \@plus2\p@ \@minus4\p@
  \itemsep \parsep
}
\let\listI\@listi
\@listi
\AtBeginDocument{%
  \let\@listi\listI
  \@listi
}
\renewcommand\@listii{%
  \leftmargin \leftmarginii
  \labelwidth \leftmarginii
  \advance\labelwidth -\labelsep
  \topsep \z@
  \parsep \z@
  \itemsep \z@
}
\renewcommand\@listiii{%
  \leftmargin \leftmarginiii
  \labelwidth \leftmarginiii
  \advance\labelwidth -\labelsep
  \topsep \z@
  \parsep \z@
  \itemsep \z@
  \partopsep \p@ \@minus\p@
 }
\newcommand*\utns@setitemindent[1]{%
  \settowidth{\labelwidth}{\utns@descriptionlabelfont #1}%
  \leftmargini \labelwidth
  \advance\leftmargini \labelsep
  \renewcommand*\@listi{%
    \leftmargin \leftmargini
    \labelwidth \leftmargini
    \advance\labelwidth -\labelsep
    \parsep \parskip
    \topsep \medskipamount
    \itemsep \parskip
    \advance\itemsep -\parsep
  }%
}
\newcommand*\utns@setitemitemindent[1]{%
  \settowidth{\labelwidth}{\utns@descriptionlabelfont #1}%
  \leftmarginii \labelwidth
  \advance\leftmarginii \labelsep
  \renewcommand*\@listii{%
    \leftmargin \leftmarginii
    \labelwidth \leftmarginii
    \advance\labelwidth -\labelsep
    \parsep \parskip
    \topsep \z@
    \itemsep \parskip
    \advance\itemsep -\parsep
  }%
}
\renewcommand*\descriptionlabel[1]{\hspace\labelsep #1\hfil}
\renewcommand*\description{%
  \@ifnextchar[{\utns@description} % ] (pour Emacs)
               {%
                 \list{}{%
                   \labelwidth\z@
                   \itemindent -\leftmargin
                   \let\makelabel\descriptionlabel
                 }%
               }%
}
\newcommand\utns@description[1][]{%
  \relax\ifnum\@listdepth=0
    \utns@setitemindent{#1}%
  \else\ifnum\@listdepth=1
    \utns@setitemitemindent{#1}%
  \fi\fi
  \list{--}{\let\makelabel\utns@descriptionlabel}%
}
\newcommand*\utns@descriptionlabel[1]{%
  \utns@descriptionlabelfont
  #1%
  \hfil
}
\newcommand*\utns@theorem@aftercount{.}
\newcommand*\utns@theorem@aftertitle{.}
\renewcommand*\newtheorem{%
  \@ifstar{\utns@theorem@withstar}{\utns@theorem@nostar}%
}
\newcommand*\utns@theorem@nostar{%
  \utns@numberedtheoremtrue
  \utns@newtheorem
}
\newcommand*\utns@theorem@withstar{%
  \utns@numberedtheoremfalse
  \utns@newtheorem
}
\newcommand*\utns@newtheorem[1]{%
  \def\utns@theorem@name{#1}%
  \expandafter\newif\csname ifutns@theorem@#1@numbered\endcsname
  \ifutns@numberedtheorem
    \csname utns@theorem@#1@numberedtrue\endcsname
  \fi
  \utns@@newtheorem
}
\newif\ifutns@newcounter
\newcommand*\utns@@newtheorem[2][]{%
  \def\utns@arg{#1}%
  \ifx\utns@arg\empty
    \expandafter\edef
      \csname utns@theorem@\utns@theorem@name @counter\endcsname
      {AA\utns@theorem@name}%
    \utns@newcountertrue
  \else
    \expandafter\ifx
        \csname utns@theorem@#1@title\endcsname
        \relax
      \ClassError{utns}
                 {#1 isn't a theorem-like environment}
                 {You have to create #1 with \string\newtheorem\space
                   before use its counter.}%
      \expandafter\edef
        \csname utns@theorem@\utns@theorem@name @counter\endcsname
        {AA\utns@theorem@name}%
      \utns@newcountertrue
    \else
      \expandafter\def
        \csname utns@theorem@\utns@theorem@name @counter\endcsname
        {AA#1}%
      \utns@newcounterfalse
    \fi
  \fi
  \expandafter\newcommand
    \csname utns@theorem@\utns@theorem@name @title\endcsname
    {#2}%
  \utns@@@newtheorem
}
\newcommand*\utns@@@newtheorem[3][]{%
  \ifutns@newcounter
    \def\utns@arg{#1}%
    \ifx\utns@arg\empty
      \newcounter{\csname utns@theorem@\utns@theorem@name @counter\endcsname}%
    \else
      \newcounter{\csname utns@theorem@\utns@theorem@name @counter\endcsname}[#1]%
      \expandafter\xdef
        \csname theutns@theorem@\utns@theorem@name @counter\endcsname{%
          \expandafter\noexpand\csname the#1\endcsname.%
          \noexpand\arabic{utns@theorem@\utns@theorem@name @counter}%
      }%
    \fi
  \fi
  \expandafter\newcommand
    \csname utns@theorem@\utns@theorem@name @titlefont\endcsname{#2}%
  \expandafter\newcommand
    \csname utns@theorem@\utns@theorem@name @bodyfont\endcsname{#3}%
  \newenvironment{\utns@theorem@name}[1][]{%
    \def\utns@theorem@optionnal{##1}%
    \par\addvspace{\VSpaceBeforeTheorem}%
    \noindent\hspace*{\HSpaceIndentTheorem}%
    \begingroup
      \csname utns@theorem@\@currenvir @titlefont\endcsname
      \csname utns@theorem@\@currenvir @title\endcsname
      \csname ifutns@theorem@\@currenvir @numbered\endcsname
        \refstepcounter{\csname utns@theorem@\@currenvir @counter\endcsname}%
        \space
        \csname the\csname utns@theorem@\@currenvir @counter\endcsname\endcsname
      \fi
      \ifx\utns@theorem@optionnal\empty
         \utns@theorem@aftercount
      \else
        \space(\utns@theorem@optionnal)%
        \utns@theorem@aftertitle
      \fi
    \endgroup
    \ifdim\HVSpaceSepTheorem<\z@
      \par\nobreak
      \vspace{-\HVSpaceSepTheorem}%
      \noindent\hspace*{\HSpaceIndentTheorem}%
    \else
      \hspace*{\HVSpaceSepTheorem}%
    \fi
    \csname utns@theorem@\@currenvir @bodyfont\endcsname
  }%
  {%
    \par\addvspace{\VSpaceAfterTheorem}
  }%
}
\newtheorem*{proof}{Proof}{\itshape}{\rmfamily}
\newtheorem{theorem}{Theorem}[section]{\bfseries}{\itshape}
\newtheorem{corollary}[theorem]{Corollary}{\bfseries}{\itshape}
\newtheorem{definition}[theorem]{Definition}{\bfseries}{\rmfamily}
\newtheorem{example}[theorem]{Example}{\itshape}{\rmfamily}
\newtheorem{exercise}[theorem]{Exercise}{\itshape}{\rmfamily}
\newtheorem{lemma}[theorem]{Lemma}{\bfseries}{\itshape}
\newtheorem{note}[theorem]{Note}{\itshape}{\rmfamily}
\newtheorem{problem}[theorem]{Problem}{\itshape}{\rmfamily}
\newtheorem{proposition}[theorem]{Proposition}{\bfseries}{\itshape}
\newtheorem{question}[theorem]{Question}{\itshape}{\rmfamily}
\newtheorem{remark}[theorem]{Remark}{\itshape}{\rmfamily}
\newtheorem{solution}[theorem]{Solution}{\itshape}{\rmfamily}
\setlength{\textfloatsep}{18\p@ \@plus 2\p@ \@minus 4\p@}
\setlength{\dbltextfloatsep}{18\p@ \@plus 2\p@ \@minus 4\p@}
\setlength{\@fptop}{\z@}
\setlength{\@fpsep}{12\p@}
\setlength{\@dblfptop}{\z@}
\setlength{\@dblfpsep}{12\p@}
\setcounter{topnumber}{4}
\renewcommand*\topfraction{.9}
\setcounter{bottomnumber}{2}
\renewcommand*\bottomfraction{.5}
\setcounter{totalnumber}{6}
\renewcommand*\textfraction{.05}
\renewcommand*\floatpagefraction{.95}
\setcounter{dbltopnumber}{3}
\renewcommand*\dbltopfraction{.9}
\renewcommand*\dblfloatpagefraction{.95}
\renewcommand*\fps@figure{tbp}
\renewcommand*\fps@table{tbp}
\def\sidecaption#1\caption{%
  \setbox0=\hbox{\ignorespaces#1\unskip}%
  \utns@sidecaptionwidth=\linewidth
  \advance\utns@sidecaptionwidth -\wd0
  \advance\utns@sidecaptionwidth -\utns@figgap
  \ifdim\utns@sidecaptionwidth<\utns@sidecaptionminwidth
    \ClassWarning{utns}{%
      No sufficient room for the legend;
      using normal \string\caption.%
    }%
    \let\utns@caption\@caption
    \unhbox0
  \else
    \let\utns@caption\utns@sidecaption
    \dimen0 \dp0
    \advance\dimen0 \ht0
    \dp0 \dp\strutbox
    \advance\dimen0-\dp0
    \ht0 \dimen0
    \unhbox0\hspace{\utns@figgap}%
  \fi
  \refstepcounter\@captype
  \@dblarg{\utns@caption\@captype}%
}
\long\def\utns@sidecaption#1[#2]#3{%
  \addcontentsline
    {\csname ext@#1\endcsname}
    {#1}
    {\protect\numberline{\csname the#1\endcsname}{\ignorespaces #2}}%
  \begingroup
    \@parboxrestore
    \utns@makesidecaption{\csname fnum@#1\endcsname}{\ignorespaces #3}%
    \par
  \endgroup
}
\newcommand*\utns@capstrut{%
  \leavevmode
  \vrule \@width\z@ \@height\ht\strutbox \@depth\z@
}
\def\utns@@makecaption#1{%
    {\utns@headcaptionfont #1\utns@floatcounterend}%
}
\long\def\utns@makesidecaption#1#2{%
  \parbox[b]{\utns@sidecaptionwidth}{%
    \utns@captionfont
    \utns@@makecaption{#1}
    \utns@capstrut
    #2%
  }%
}
\renewcommand\@makecaption[2]{%
  \utns@captionfont
  \ifx\@captype\utns@figtype
    \par\vskip\VSpaceBeforeFigCaption
    \utns@@makecaption{#1}%
    \utns@capstrut%
    #2%
    \par
  \else
    {\utns@headcaptionfont #1\utns@floatcounterend}%
    \utns@capstrut
    #2%
    \par
    \vskip\VSpaceAfterTabCaption
  \fi
}
\newcommand\tablebib[1]{\VSpaceBeforeTabFoot=1ex%
  \par\vspace{\VSpaceBeforeTabBib}
  \noindent
  \begin{minipage}{\linewidth}
    {\utns@tablebibnamefont\utns@tablebibname.}~%
    \utns@tablebibfont
    \ignorespaces
    #1%
  \end{minipage}%
}
\newcommand\tablefoot[1]{\VSpaceBeforeTabBib=1ex%
  \par\vspace{\VSpaceBeforeTabFoot}
  \noindent
  \begin{minipage}{\linewidth}
    {\utns@tablefootnamefont\utns@tablefootname.}~%
    \utns@tablefootfont
    \ignorespaces
    #1%
  \end{minipage}%
}
\newcommand*\tablefootmark[1]{%
  \unskip
  \hbox{\@textsuperscript{\normalfont\itshape\ignorespaces#1}}%
  \,%
  \ignorespaces
}
\newcommand\tablefoottext[2]{%
  \hbox{\@textsuperscript{\normalfont({\itshape\ignorespaces#1})}}%
  ~%
  \ignorespaces
  #2\ \ignorespaces%
}
\setlength\bibindent{1em}
\renewenvironment{thebibliography}[1]{%
  \begingroup
  \section*{\refname}%
  \@mkboth{\refname}{\refname}%
  \utns@bibliographyfont
  \list{\@biblabel{\@arabic\c@enumiv}}%
  {%
    \settowidth\labelwidth{\@biblabel{#1}}%
    \ifutns@bibnumber
    \leftmargin\labelwidth
    \advance\leftmargin\labelsep
    \else
    \leftmargin\bibindent
    \setlength{\itemindent}{-\leftmargin}
    \fi
    \@openbib@code
    \usecounter{enumiv}%
    \let\p@enumiv\@empty
    \renewcommand\theenumiv{\@arabic\c@enumiv}%
  }%
  \sloppy
  \clubpenalty4000
  \@clubpenalty \clubpenalty
  \widowpenalty4000%
  \sfcode`\.\@m
}{%
  \endlist\par\endgroup%
  \ifutns@longauth\kern6pt\hrule\kern6pt\utnsinstitutename\utns@longauthfalse\fi%
  \ifutns@referee\if!\csname longtab\endcsname!\relax\else\listofobjects\fi\fi
  \Finlongtab%
  \def\@noitemerr{\ClassWarning{utns}{Empty `thebibliography' environment}}%
}
\def \@floatboxreset {%
     \reset@font
     \ifx\@captype\utns@tabtype
       \small
       \spacetab
     \fi
     \@setnobreak
     \@setminipage
}
\def\spacetab{%
\abovedisplayshortskip-10pt%
\belowdisplayshortskip0pt%
}
\DeclareRobustCommand{\ion}[2]{\textup{#1\,\textsc{\lowercase{#2}}}}
\newcommand*\element[1][]{%
  \def\utns@element@tr{#1}%
  \utns@element
}
\newcommand*\utns@element[1][]{%
  \def\utns@element@tl{#1}%
  \utns@@element
}
\newcommand*\utns@@element[1][]{%
  \def\utns@element@bl{#1}%
  \utns@@@element
}
\newcommand*\utns@@@element[2][]{%
  \def\utns@element@br{#1}%
  \ensuremath{%
    \vphantom{x}^{\utns@element@tl}_{\utns@element@bl}
    \mathrm{#2}
    \vphantom{x}^{\utns@element@tr}_{\utns@element@br}
  }%
}
\renewcommand*\vec[1]{\ensuremath{\mathbf{#1}}}
\newcommand*\tens[1]{\ensuremath{\mathsf{#1}}}
\newcommand*\sq{%
  \ifmmode
    \Box
  \else
    \begingroup
      \unskip\nobreak
      \hfil
      \penalty50
      \hskip1em
      \null\nobreak\hfil$\Box$%
      \parfillskip=0pt
      \finalhyphendemerits=0
      \endgraf
    \endgroup
  \fi
}
\newcommand*\sun{\ensuremath{\odot}}
\newcommand*\degr{\ensuremath{^\circ}}
\newcommand*\arcmin{\ensuremath{^\prime}}
\newcommand*\arcsec{\ensuremath{^{\prime\prime}}}
\def\utw{\ensuremath{\smash{\rlap{\lower5pt\hbox{$\sim$}}}}}
\def\udtw{\ensuremath{\smash{\rlap{\lower6pt\hbox{$\approx$}}}}}
\newcommand*\fd{\ensuremath{\overset{\text{d}}{.}}}
\newcommand*\fh{\ensuremath{\overset{\text{h}}{.}}}
\newcommand*\fm{\ensuremath{\overset{\text{m}}{.}}}
\newcommand*\fs{\ensuremath{\overset{\text{s}}{.}}}
\newcommand*\fdg{\ensuremath{\overset{\circ}{.}}}
\newcommand*\farcm{\ensuremath{\overset{\prime}{.}}}
\newcommand*\farcs{\ensuremath{\overset{\prime\prime}{.}}}
\newcommand*\fp{\ensuremath{\overset{\scriptscriptstyle\text{p}}{.}}}
\newcommand*\cor{\ensuremath{\mathrel{\widehat{=}}}}
\newcommand*\utns@centerstack[2]{%
  \ensuremath{%
    \mathrel{%
      \mathchoice{%
        \vcenter{%
          \offinterlineskip
          \halign{\hfil$\displaystyle##$\hfil\cr#1\cr#2\cr}%
        }%
      }
      {%
        \vcenter{%
          \offinterlineskip
          \halign{\hfil$\textstyle##$\hfil\cr#1\cr#2\cr}%
        }%
      }
      {%
        \vcenter{%
          \offinterlineskip
          \halign{\hfil$\scriptstyle##$\hfil\cr#1\cr#2\cr}%
        }%
      }
      {%
        \vcenter{%
          \offinterlineskip
          \halign{\hfil$\scriptscriptstyle##$\hfil\cr#1\cr#2\cr}%
        }%
      }%
    }%
  }%
}
\newcommand*\la{\utns@centerstack{<}{\sim}}
\newcommand*\ga{\utns@centerstack{>}{\sim}}
\newcommand*\sol{\utns@centerstack{\sim}{<}}
\newcommand*\sog{\utns@centerstack{\sim}{>}}
\newcommand*\lse{\utns@centerstack{<}{\simeq}}
\newcommand*\gse{\utns@centerstack{>}{\simeq}}
\newcommand*\utns@centerstackskip[6]{%
  \ensuremath{%
    \mathrel{%
      \mathchoice{%
        \vcenter{%
          \offinterlineskip
          \halign{\hfil$\displaystyle##$\hfil\cr
            #1\cr\noalign{\vskip#3}#2\cr}%
        }%
      }
      {%
        \vcenter{%
          \offinterlineskip
          \halign{\hfil$\textstyle##$\hfil\cr
            #1\cr\noalign{\vskip#4}#2\cr}%
        }%
      }
      {%
        \vcenter{%
          \offinterlineskip
          \halign{\hfil$\scriptstyle##$\hfil\cr
            #1\cr\noalign{\vskip#5}#2\cr}%
        }%
      }
      {%
        \vcenter{%
          \offinterlineskip
          \halign{\hfil$\scriptscriptstyle##$\hfil\cr
            #1\cr\noalign{\vskip#6}#2\cr}%
        }%
      }%
    }%
  }%
}
\newcommand*\grole{\utns@centerstackskip{>}{<}{-1.5\p@}{-1.5\p@}{-1\p@}{-.5\p@}}
\newcommand*\leogr{\utns@centerstackskip{<}{>}{-1.5\p@}{-1.5\p@}{-1\p@}{-.5\p@}}
\newcommand*\loa{\utns@centerstack{<}{\approx}}
\newcommand*\goa{\utns@centerstack{>}{\approx}}
\newcommand*\diameter{%
  \ensuremath{%
    \mathchoice{%
      \ooalign{%
        \hfil\hbox{$\displaystyle/$}\hfil\crcr
        {\hbox{$\displaystyle\mathchar"20D$}}%
      }%
    }
    {%
      \ooalign{%
        \hfil\hbox{$\textstyle/$}\hfil\crcr
        {\hbox{$\textstyle\mathchar"20D$}}%
      }%
    }
    {%
      \ooalign{%
        \hfil\hbox{$\scriptstyle/$}\hfil\crcr
        {\hbox{$\scriptstyle\mathchar"20D$}}%
      }%
    }
    {%
      \ooalign{%
        \hfil\hbox{$\scriptscriptstyle/$}\hfil\crcr
        {\hbox{$\scriptscriptstyle\mathchar"20D$}}%
      }%
    }%
  }%
}
\let\olddiameter\diameter
\newcommand*\getsto{\utns@centerstack{\gets}{\to}}
\newcommand*\lid{\utns@centerstackskip{<}{=}{1.2\p@}{1.2\p@}{1\p@}{0.9\p@}}
\newcommand*\gid{\utns@centerstackskip{>}{=}{1.2\p@}{1.2\p@}{1\p@}{0.9\p@}}
\newcommand*\bbbone{%
  \ensuremath{%
    \mathchoice{\mathrm 1\mskip-4mu l}
               {\mathrm 1\mskip-4mu l}
               {\mathrm 1\mskip-4.5mu l}
               {\mathrm 1\mskip-5mu l}%
  }%
}
\DeclareMathAlphabet{\mathsfsl}{OT1}{txss}{m}{sl}
\g@addto@macro{\endlongtable}{\addvspace{-3.5mm}}
\AtBeginDocument{%
\@ifpackageloaded{lscape}{%
\g@addto@macro{\landscape}{\centering\setlength{\LTcapwidth}{\utns@fullheight}}}{}
\@ifpackageloaded{pdflscape}{%
\g@addto@macro{\landscape}{\centering\setlength{\LTcapwidth}{\utns@fullheight}}}{}
\@ifpackageloaded{utnslongtable}%
{\def\LS@rot{%
  \setbox\@outputbox\vbox
  to\utns@fullheight{\vfill\centerline{\rotatebox{90}{\box\@outputbox}}\vfill}}}{}
\@ifpackageloaded{subfigure}%
{\renewcommand*{\thesubfigure}{\alph{subfigure}}
\renewcommand*{\@thesubfigure}{(\thesubfigure)\hskip\subfiglabelskip}
\renewcommand*{\@@thesubfigure}{(\thesubfigure)}%
\renewcommand*{\thesubtable}{\alph{subtable}}
\renewcommand*{\@thesubtable}{(\thesubtable)\hskip\subfiglabelskip}
\renewcommand*{\@@thesubtable}{(\thesubtable)}}{}
\@ifpackageloaded{wasysym}%
{\let\diameter\olddiameter}{}

}
\setlength\leftmargini  {\parindent}
\leftmargin  \leftmargini
\setlength\leftmarginii {\parindent}
\setlength\leftmarginiii {1.87em}
\setlength\leftmarginiv  {1.7em}
\setlength\leftmarginv  {.5em}
\setlength\leftmarginvi {.5em}
\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\renewcommand\labelenumi{\theenumi.}
\renewcommand\labelenumii{(\theenumii)}
\renewcommand\labelenumiii{\theenumiii.}
\renewcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\renewcommand\labelitemi{\normalfont\bfseries --}
\renewcommand\labelitemii{\normalfont\bfseries --}
\renewcommand\labelitemiii{$\m@th\bullet$}
\renewcommand\labelitemiv{$\m@th\cdot$}
\def\arxivprefixe{arXiv}
\def\arxivprefixesep{:}
\def\arxiv#1{%
{\tt \arxivprefixe\arxivprefixesep\ignorespaces#1}%
}
\newcommand{\eprint}[2][]{{\tt\if!#1!#2\else#1:#2\fi}}
\endinput
%%
%% End of file `utns.cls'.